/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.View;
import de.willuhn.jameica.gui.input.QueryInput;
import de.willuhn.jameica.gui.internal.action.SearchOptions;
import de.willuhn.jameica.gui.internal.parts.SearchResultPart;
import de.willuhn.jameica.gui.parts.Panel;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.search.SearchResult;
import de.willuhn.jameica.services.SearchService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SearchPart
implements Part {
    private static final KeyStroke SHORTCUT_DEFAULT = KeyStroke.getInstance((int)262144, (int)49);
    private static final Settings settings = new Settings(SearchPart.class);
    private KeyStroke currentKey = null;
    private QueryInput search = null;
    private boolean started = false;

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.search = new QueryInput(){

            @Override
            public void doSearch(String query) {
                SearchPart.this.startSearch();
            }
        };
        this.search.setHint(Application.getI18n().tr("Suche...") + "   (" + this.getKeyStroke().format() + ")");
        this.search.paint(parent);
        GUI.getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                KeyStroke ks = SearchPart.this.getKeyStroke();
                if (ks == null) {
                    return;
                }
                char c = (char)ks.getNaturalKey();
                if (Character.isLetter(c)) {
                    c = Character.toLowerCase(c);
                }
                if (event.stateMask == ks.getModifierKeys() && event.keyCode == c) {
                    SearchPart.this.search.focus();
                }
            }
        });
    }

    private void startSearch() {
        if (this.search == null) {
            return;
        }
        String text = (String)this.search.getValue();
        if (text == null || text.length() < 3) {
            return;
        }
        try {
            final View view = GUI.getView();
            if (this.started) {
                view.snapOut();
                this.started = false;
            }
            SearchService service = (SearchService)Application.getBootLoader().getBootable(SearchService.class);
            List<SearchResult> result = service.search(text);
            SearchResultPart part = new SearchResultPart(result);
            Panel panel = new Panel(Application.getI18n().tr("Suchergebnis"), part, false);
            panel.addMinimizeListener(new Listener(){

                public void handleEvent(Event event) {
                    view.snapOut();
                    SearchPart.this.started = false;
                }
            });
            if (!Customizing.SETTINGS.getBoolean("application.search.hideoptions", false)) {
                panel.addButton(new PanelButton("document-properties.png", new SearchOptions(), Application.getI18n().tr("Such-Optionen konfigurieren")));
            }
            panel.paint(view.getSnapin());
            view.snapIn();
            this.started = true;
        }
        catch (Exception ex) {
            Logger.error((String)"error while opening search result", (Throwable)ex);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Anzeigen des Suchergebnisses: {0}", ex.getMessage()), 1));
        }
    }

    public String getShortcut() {
        return this.getKeyStroke().format();
    }

    public void setShortcut(String shortcut) {
        if ((shortcut = StringUtils.trimToNull((String)shortcut)) == null) {
            settings.setAttribute("shortcut", null);
        } else {
            KeyStroke ks = SWTUtil.getKeyStroke(shortcut);
            if (ks == null) {
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Tastenkombination ung\u00fcltig: {0}", shortcut), 1));
            }
            settings.setAttribute("shortcut", ks != null ? ks.format() : null);
        }
        this.currentKey = null;
        if (this.search != null) {
            this.search.setHint(Application.getI18n().tr("Suche...") + "   (" + this.getKeyStroke().format() + ")");
        }
    }

    private KeyStroke getKeyStroke() {
        if (this.currentKey != null) {
            return this.currentKey;
        }
        this.currentKey = SWTUtil.getKeyStroke(settings.getString("shortcut", null));
        if (this.currentKey == null) {
            this.currentKey = SHORTCUT_DEFAULT;
        }
        return this.currentKey;
    }
}

